/*
Zebra solver, a program for brute forcing "Who owns the zebra"-style puzzles
Copyright (C) 2004  Vidar Holen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.*;

/* This class does all the stuff. 
 * It was late, so I didn't bother doing it properly. 
 * Vidar 'koala_man' Holen
 * 21.01.2004
*/
public class Zebra extends JPanel implements ActionListener, ChangeListener {
    final static int MAX_CAT=8, MAX_ELEM=8;
   
    ArrayList rulelist=new ArrayList();
    JTabbedPane jtp;
    JPanel intro, names;
    Solver solve;
    RulEd rules;
    Component oldcomp;
    JTable table;
    JButton clear, prev, next;
    String[][] data=new String[MAX_CAT][MAX_ELEM+1];
    int numcat=0, numelem=1;
    
    public Zebra() {
        setLayout(new BorderLayout());
        jtp=new JTabbedPane();
        names=new JPanel();
        rules=new RulEd();
        solve=new Solver();
        intro=new JPanel();
        clear=new JButton("Clear");
        prev=new JButton("Previous");
        next=new JButton("Next");
        
        names.setLayout(new GridLayout());
        
        clearData();
        
        JTextArea jep=new JTextArea(
                "Zebra Solver! \n\n"+
                "This applet will solve puzzles such as \"Who owns the zebra?\" "+
                "where a number of people live in a number of houses, with a number "+
                "of drinks, nationalities and pets, and a number of rules like "+
                "\"The englishman lives next to the white house.\" and "+
                "\"The person who drinks tea has a cat.\"\n\n"+

                "Your job in this is to read through the rules and extract "+
                "categories and their elements, such as "+
                "\"Pet: Cat, Dog, Bird, Horse, Zebra\" (Names tab),"+
                "then input the rules (Rules tab). If the norwegian has a cat, the "+
                "rule is \"Nationality norwegian is with Pet cat\", it shouldn't be too"+
                "hard to figure out. \n\n"+
                "Finally, the Solver tab will "+
                "let you start the search for solutions. This will take a while "+
                "but you probably have nothing better to do than to watch it. I didn't bother fixing all concurency issues, so don't change stuff while running the search. \n\n\n"+

                "Vidar 'koala_man' Holen, www.vidarholen.net\n"+
                "This software is released under the GNU General Public License"
                );
        jep.setEnabled(false); 
        jep.setLineWrap(true);
        jep.setWrapStyleWord(true);
        intro.setLayout(new GridLayout(1,1));
        intro.add(jep);
        
        jtp.addTab("Intro",null,intro,"A little usage information");
        jtp.addTab("Names",null,names,"Define categories and elements");
        jtp.addTab("Rules",null,rules,"Define rules");
        jtp.addTab("Solver",null,solve,"Find the solution");
        
        table=new JTable(new InputModel());
        table.setCellSelectionEnabled(true);
        names.add(new JScrollPane(table));

        JPanel tmp=new JPanel();
        tmp.setLayout(new FlowLayout());
        tmp.add(clear);
        tmp.add(prev);
        tmp.add(next);

        jtp.addChangeListener(this);
        clear.addActionListener(this);
        next.addActionListener(this);
        prev.addActionListener(this);

        add(jtp, "Center");
        add(tmp, "South");
    }
    public void stateChanged(ChangeEvent e) {
        Component c=jtp.getSelectedComponent();
        if(c==intro) {
            clear.setEnabled(false);
            prev.setEnabled(false);
        } else {
            clear.setEnabled(true);
            prev.setEnabled(true);
        }
        if(oldcomp==names) {
            scanTable();
            rules.refreshList();
            rules.updateChoices();
        }
        oldcomp=c;
    }
    public void actionPerformed(ActionEvent e) { 
        Object a=e.getSource(), b=jtp.getSelectedComponent();
        if(a==clear) {
            if(b==names) {
                clearData();
                table.repaint();
            } else if(b==rules) {
                rulelist.clear();
                rules.clearView();
                rules.refreshList();
            }
        } else if(a==next) {
            jtp.setSelectedIndex((jtp.getSelectedIndex()+1)%4);
        } else if(a==prev) {
            jtp.setSelectedIndex((jtp.getSelectedIndex()+3)%4);
        }
    }

    void scanTable() {
        int i,j,m=0;
        for(i=0; i<data.length && !data[i][0].equals(""); i++) {
            for(j=1; j<data[i].length && !data[i][j].equals(""); j++);
            if(j>m) m=j;
        }
        numcat=i; numelem=m;
        table.clearSelection();
        table.setRowSelectionInterval(1,numcat);
        table.setColumnSelectionInterval(1,numelem);
        System.out.println(numcat+" rows, "+numelem+" cols");
    }
    void clearData() {
        for(int i=0; i<data.length; i++)
            for(int j=0; j<data[i].length; j++)
                data[i][j]="";
    }

    class InputModel extends AbstractTableModel {
        public Class getColumnClass(int col) {
            return String.class;
        }
        public int getColumnCount() { 
            return MAX_ELEM+1;
        }
        public String getColumnName(int i) { 
            if(i==0) return "Category";
            else return "Item "+i;
        }
        public int getRowCount() {
            return MAX_CAT;
        }
        public void setValueAt(Object o, int row, int col) {
            data[row][col]=(String)o;
            super.setValueAt(o,row,col);
        }
        public Object getValueAt(int row, int col) {
            return data[row][col];
        }
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
    private class RulEd extends JPanel implements ActionListener {
        JComboBox c1, n1, c2, n2, r, m;
        JButton add,del;
        JList list;
        Rule cow=new Rule();
        public RulEd() {
            setLayout(new BorderLayout());
            list=new JList();
            add(list,BorderLayout.CENTER);
            c1=new JComboBox();
            n1=new JComboBox();
            c2=new JComboBox();
            n2=new JComboBox();
            r=new JComboBox();
            m=new JComboBox();

            for(int i=0; i<cow.getRelations().length; i++)
                r.addItem(cow.getRelations()[i]);
            for(int i=0; i<cow.getModes().length; i++)
                m.addItem(cow.getModes()[i]);
            
            JPanel tmp=new JPanel();
            add=new JButton("Add");
            del=new JButton("Delete");
            
            add.addActionListener(this);
            del.addActionListener(this);
            c1.addActionListener(this);
            c2.addActionListener(this);
            
            tmp.setLayout(new FlowLayout());
            tmp.add(c1); tmp.add(n1); 
            tmp.add(r); tmp.add(m);
            tmp.add(c2); tmp.add(n2); 
            tmp.add(add); tmp.add(del);
            add(tmp, BorderLayout.SOUTH);

        }
        public void actionPerformed(ActionEvent e) {
            if(e.getSource()==add) {
                int a=c1.getSelectedIndex();
                int b=n1.getSelectedIndex();
                int c=c2.getSelectedIndex();
                int d=n2.getSelectedIndex();
                int g=r.getSelectedIndex();
                int f=m.getSelectedIndex();
                if((a*b*c*d)==0) return;
                rulelist.add(new Rule(a-1,b-1,c-1,d-1,g,f));
                updateChoices();
                clearView();
            } else if(e.getSource()==del) {
                if(rulelist.size()!=0) 
                    rulelist.remove(list.getSelectedIndex());
                updateChoices();
                clearView();
            } else if(e.getSource()==c1) {
                if(c1.getSelectedIndex()!=0) 
                    fillCat(c1.getSelectedIndex()-1, n1);
            } else if(e.getSource()==c2) {
                if(c2.getSelectedIndex()!=0)
                    fillCat(c2.getSelectedIndex()-1, n2);
            }
            refreshList();
        }
        protected void fillCat(int c, JComboBox n) {
            n.removeAllItems();
            n.addItem("");
            if(c==numcat) 
                for(int i=1; i<numelem; i++)
                    n.addItem("#"+i);
            else
            if(c!=-1)
                for(int i=1; i<numelem; i++) 
                    n.addItem(data[c][i].equals("")?"Unknown"+i:data[c][i]);
        }
        
        public void clearView() {
            c1.setSelectedIndex(0);
            n1.setSelectedIndex(0);
            c2.setSelectedIndex(0);
            n2.setSelectedIndex(0);
            r.setSelectedIndex(0);
            m.setSelectedIndex(0);
        }
        public void refreshList() {
            list.setListData(rulelist.toArray());
        }
        public void updateChoices() {
            c1.removeAllItems();
            c2.removeAllItems();
            n1.removeAllItems();
            n2.removeAllItems();
            n1.addItem("");
            n2.addItem("");
            c1.addItem("");
            c2.addItem("");
            table.clearSelection();
            int i;
            for(i=0; i<numcat; i++) {
                c1.addItem(data[i][0]);
                c2.addItem(data[i][0]);
            }
            c1.addItem("[Position]");
            c2.addItem("[Position]");
        } 
            
    }
    private class Rule {
        protected Rule(int c1, int n1, int c2, int n2, int r, int m) {
            cat1=c1; num1=n1; cat2=c2; num2=n2; rel=r; mode=m;
        }
        protected Rule() {}
        protected int cat1, num1, cat2, num2, rel, mode;

        public String toString() {
            return (cat1==numcat?"Position":data[cat1][0])+" "+
                (cat1==numcat?"#"+(num1+1):data[cat1][num1+1])+" "+
                getRelations()[rel]+" "+getModes()[mode]+" "+
                (cat2==numcat?"Position":data[cat2][0])+" "+
                (cat2==numcat?"#"+(num2+1):data[cat2][num2+1]);
        }
        public String[] getRelations() {
            return new String[] { "is", "is not" };
        }
        public String[] getModes() {
            return new String[] { "with", "left of", "right of", "next to"};
        }
    }
    private class Solver extends JPanel implements Runnable, ActionListener {
        JProgressBar jpb;
        int jpbmax;
        JButton start;
        JTable jt;
        InputModel im;
        boolean run; 
        int[][] perm;
        int permc;
        int[][] house;
        int[] hs;
        ArrayList sols;
        
        public Solver() {
            setLayout(new BorderLayout());
            jpb=new JProgressBar();
            jpb.setMinimum(0);
            jpb.setStringPainted(true);
            start=new JButton();
            sols=new ArrayList();
            im=new InputModel();
            jt=new JTable(im);
            setupPerms();
            reset();
            stopProcessing();
            start.addActionListener(this);

            JPanel jp=new JPanel();
            jp.setLayout(new GridLayout(2,1));
            jp.add(jpb);
            jp.add(start);
            add(new JScrollPane(jt),BorderLayout.CENTER);
            add(jp, BorderLayout.SOUTH);
        }
        void reset() {
            jpb.setMaximum(jpbmax=calcMoves());
            System.out.println("Max moves "+calcMoves());
            jpb.setValue(0);
            jpb.setString("");
            house=new int[numelem-1][];
            for(int i=0; i<numelem-1; i++)
                house[i]=perm[0];
            hs=new int[house.length];
            sols.clear();
            im.fireTableStructureChanged();
        }   
        int calcMoves() {
            long l=1,n;
            n=calcPerm();
            for(int i=0; i<numcat; i++) l*=n;
            return (int)(l>>20);
        }
        int calcPerm() {
            int n=1;
            for(int i=2; i<numelem; i++) n*=i;
            return n;
        }
        void setupPerms() {
            permc=0;
            perm=new int[calcPerm()][];
            int[] unused=new int[numelem-1], ns=new int[numelem-1];
            permute(unused,ns,0,numelem-1);
            assert permc==calcPerm() : "Damn combinatorics";
        }
        void permute(int[] unused, int[] ns, int l, int n) {
            if(l==n) {
                int[] nn=new int[numelem-1];
                for(int i=0; i<n; i++) 
                    nn[i]=ns[i];
                perm[permc++]=nn;
            } else {
                for(int i=0; i<n; i++) 
                    if(unused[i]==0) {
                        unused[i]=1;
                        ns[l]=i;
                        permute(unused,ns,l+1,n);
                        unused[i]=0;
                    }
            }
        }
        void startProcessing() {
            start.setText("Abort.");
            setupPerms();
            reset();
            run=true;
            System.out.println("Starting..");
            Thread t=new Thread(this);
            t.start();
            System.out.println("Nowthen..?");
        }
        void stopProcessing() {
            run=false;
            start.setText("Start!");
        }
        public void actionPerformed(ActionEvent e) {
            if(e.getSource()==start) {
//                synchronized(this) {
                    if(run) stopProcessing();
                    else startProcessing();
//                }
//                System.out.println("Drop sync");
            }
        }
        boolean checkRules() {
            for(int i=0; i<rulelist.size(); i++) {
                if(!checkRule((Rule)rulelist.get(i))) {
//                    System.out.println("False!");
                    return false;
                }
//                System.out.println("True");
            }
            return true;
        }
        boolean checkRule(Rule r) {
            int a=-1, b=-1,c;
            
            /*
            System.out.println(r.cat1+", "+r.cat2+", "+r.num1+", "+r.num2+" "+(numelem-1));
            for(int i=0; i<house.length; i++)  {
                for(int j=0; j<house[i].length;j++)
                    System.out.print(house[i][j]+", ");
                System.out.println();
            }
            */
            if(r.cat1==numcat) a=r.num1;
            else for(int i=0; i<numelem-1; i++) 
                if(house[r.cat1][i]==r.num1) {
                    a=i; break;
                }
            if(r.cat2==numcat) b=r.num2;
            else for(int i=0; i<numelem-1; i++) 
                if(house[r.cat2][i]==r.num2) {
                    b=i; break;
                }
            c=b-a;
            switch(r.mode) {
                case 0: //with
                    if(c==0) return r.rel==0;
                    else return r.rel==1;
                case 1: //left
                    if(c==1) return r.rel==0;
                    else return r.rel==1;
                case 2: //right
                    if(c==-1) return r.rel==0;
                    else return r.rel==1;
                case 3: //nextto
                    if(c==-1 || c==1) return r.rel==0;
                    else return r.rel==1;
                default:
                    assert false : "What kind of mode is this?";
                    return false;
            }
            
        }
        void addSolution() {
            int [][] copy= new int[house.length][];
            for(int i=0; i<copy.length; i++) {
                copy[i]=new int[house[i].length];
                for(int j=0; j<house[i].length; j++)
                    copy[i][j]=house[i][j];
            }
            System.out.println("AddSolution");
            sols.add(copy);
            im.fireTableStructureChanged();
        }
        public void run() {
            int i, step=0, permmod=0;
            long lasttime=System.currentTimeMillis();
            while(run) {

                if(checkRules())
                    addSolution();
                
                i=0;
                house[0]=perm[hs[0]];
                while(i<hs.length && ++hs[i] == perm.length) {
                    hs[i]=0;
                    i++;
                }
                if(i==hs.length) break;
                for(;i>=0; i--)
                    house[i]=perm[hs[i]];
                permmod++;
                if((permmod&0x0fffff)==0) {
                    long diff=System.currentTimeMillis()-lasttime;
                    lasttime=diff+lasttime;
                    permmod=0;
                        if(run) {
                            jpb.setValue(step);
                            jpb.setString(diff*(jpbmax-step)/1000/60+"min left");
                        }
                    step++;
                }
            }
            System.out.println("end "+run+", "+step+"+"+permmod);
            stopProcessing();
        }
        class InputModel extends AbstractTableModel {
            public int getColumnCount() {
                return numelem;
            }
            public String getColumnName(int i) {
                if(sols.size()==0) return "No solutions yet";
                if(i==0) return "Category";
                else return "Position "+i;
            }
            public int getRowCount() {
                return sols.size()*(numcat+1);
            }
            public void setValueAt(Object o, int row, int col) {
            }
            public Object getValueAt(int row, int col) {
                int sol=row/(numcat+1);
                int n=row%(numcat+1);
                if(n==numcat) return "";
                if(col==0) return data[n][0];
                else return data[n][((int[][])sols.get(sol))[n][col-1]+1];
            }
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }
}


